<?php

$search = new NLBookingAPISearchHotelsParams();

$search->addCurrency(17);           // Устанавливаем валюту
$search->addCity(29);               // Устанавливаем город, если нужно искать по городу
$search->addHotel(100);              // Устанавливаем отель, если поиск по одному отелю
$search->addPeriod('2020-12-20', '2020-12-23'); // Устанавливаем период
$search->addAdults(2);              // Устанавливаем количество взрослых
$search->addChildren(1, [4]);    // Устанавливаем количество детей и их возрасты
$search->addAvailability('all');    // Устанавливаем доступность номеров. Допустимые значения: "online" - доступны для моментального бронирования, "onrequest" - доступны по запросу, "all" - все
$search->addPriceDetail(0);         // Устанавливаем детализацию цен. Допустимые значения: "0" - выключена детализация цен по дням, "1" - включена. При выключеном значении в ответе приходит только общая цена за каждый номер. Если детализация цен по дням включена, то в ответе приходит общая цена за каждый номер, а также детальная информация о цене за каждый день.
$search->addOneRoom(1);             // Устанавливаем один номер. Допустимые значения: "0" - параметр выключен, "1" - параметр включен. При включеном значении в ответе приходит только один номер отеля со всеми его вариантами тарифных планов. Если параметр выключен, то в ответе приходят все номера отелей со всеми вариантами тарифных планов.
$search->addPage(1);                // Устанавливаем страницу. Допускается любое целое число. При значении "0" постраничный просмотр отключен.
$search->addPerPage(10);            // Устанавливаем количество отелей на странице. Допускается любое целое число.

$rs = $api->searchHotels($search);  // Поиск отелей по параметрам
