<?php

set_time_limit(0);

// Load integrator
require_once 'NLBookingAPI.php';

try {

    ini_set('soap.wsdl_cache_enabled', '0');    // отключение кеширования wsdl файла. На production версии кеширование нужно включить

    $api = new NLBookingAPI();

    // Настройка подключения
    $api->setWSDL('http://api.newlogic.ua/api/v3/wsdl/');   // Устанавливаем путь к WSDL
    $api->setCredentials('email', 'password');              // Устанавливаем логин и пароль
    $api->setLanguage('ru');                                // Устанавливаем язык ответа сервиса

    // Вкл/Выкл режима отладки
    $debug = true;
    $api->setDebug($debug);

    /**
     * Пример вызова всех методов API. Раскомментируйте интересующий метод.
     */
    /**
     * Получение статических данных
     */
    include 'examples/staticData.php';

    /**
     * Поиск отелей
     */
//    include 'examples/searchHotels.php';

    /**
     * Получение цен раннего заезда/позднего выезда отеля
     */
//    include 'examples/getHotelOvertime.php';

    /**
     * Получение доплат отеля
     */
//    include 'examples/getHotelSurcharges.php';

    /**
     * Поиск экскурсий
     */
//    include 'examples/searchExcursions.php';

    /**
     * Поиск трансферов
     */
//    include 'examples/searchTransfers.php';

    /**
     * Оформление заказа
     */
//    include 'examples/addOrder.php';

    /**
     * Поиск заказов
     */
//    include 'examples/searchOrders.php';

    /**
     * Получение информации о заказе
     */
//    include 'examples/getOrder.php';

    /**
     * Редактирование заказа
     */
//    include 'examples/editOrder.php';

    /**
     * Симулировать редактирование заказа
     */
//    include 'examples/simulateEditOrder.php';

    /**
     * Подтверждение заказа
     */
//    include 'examples/confirmOrder.php';

    /**
     * Отмена заказа
     */
//    include 'examples/cancelOrder.php';

//    echo '<pre>';
//    print_r($rs);
//    echo '</pre>';

    // Debug
    if ($debug) {
        $client = $api->getConnect();
        echo 'Request:<br /><textarea style="width: 1300px; height: 150px">' . htmlspecialchars($client->__getLastRequest()) . '</textarea>';
        echo '<br />Response:<br /><textarea style="width: 1300px; height: 500px">' . htmlspecialchars($client->__getLastResponse()) . '</textarea>';
    }
} catch (Exception $e) {
    echo 'Error found: ' . $e->getMessage();
    echo '<pre>';
    print_r($e->getTraceAsString());
    echo '</pre>';
}
